import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Tag from 'lego/components/Tag';
import cx from 'classnames';
import { FormattedDate } from 'react-intl';
import { createStaffUrl } from 'utils/createStaffUrl';
import css from './Form.scss';
import { TAG_COLOR } from '../../constants';
import NativeForm from './NativeForm';
import { Unit } from './types';

const tags = [
  {
    color: TAG_COLOR.ACTIVE,
    name: 'active',
    text: 'Активен',
  },
  {
    color: TAG_COLOR.DISMISSED,
    name: 'isDismissed',
    text: 'Уволен',
  },
  {
    color: TAG_COLOR.MANAGER,
    name: 'isManager',
    text: 'Менеджер',
  },
  {
    color: TAG_COLOR.TEAMLEAD,
    name: 'isTeamlead',
    text: 'Тимлид',
  },
  {
    color: TAG_COLOR.ADMIN,
    name: 'isAdmin',
    text: 'Админ',
  },
  {
    color: TAG_COLOR.SUPERREADER,
    name: 'isSuperreader',
    text: 'Суперсмотритель',
  },
  {
    color: TAG_COLOR.SUPPORT,
    name: 'isSupport',
    text: 'Поддержка',
  },
];

interface Props {
  // eslint-disable-next-line
  data: any;
  units: Unit[];
  className?: string;
  // eslint-disable-next-line
  config?: any;
  // eslint-disable-next-line
  initialValues?: any;
  onSubmit: () => void;
  getInnerRef?: React.Ref<HTMLDivElement>;
  hash: number;
}

const Form = (props: Props): React.ReactElement => {
  const { data, units, className, config, initialValues, onSubmit, getInnerRef, hash } = props;

  return (
    <div className={cx(css.b, className)} ref={getInnerRef}>
      <div className={css.b__header}>
        <Button view="action" onClick={onSubmit}>
          Сохранить
        </Button>
      </div>
      <div className={css.b__content}>
        <img
          className={css.b__img}
          src={`//center.yandex-team.ru/api/v1/user/${data.user.login}/photo/128.jpg`}
          alt=""
        />
        <div className={css.b__row}>
          <div className={css.b__label}>Синхронизация</div>
          <div className={css.b__field}>
            <FormattedDate
              value={new Date(data.user.idmSyncDt)}
              year="numeric"
              month="numeric"
              day="numeric"
              hour="numeric"
              minute="numeric"
              second="numeric"
            />
          </div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>Изменил</div>
          <div className={css.b__field}>
            <FormattedDate
              value={new Date(data.user.modifiedOn)}
              year="numeric"
              month="numeric"
              day="numeric"
              hour="numeric"
              minute="numeric"
              second="numeric"
            />
            &nbsp;
            {data.user.modifiedBy}
          </div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>ID</div>
          <div className={css.b__field}>{data.user.id}</div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>ФИО</div>
          <div className={css.b__field}>{data.user.name}</div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>Login</div>
          <div className={css.b__field}>
            <a href={createStaffUrl(data.user.login)} target="_blank" rel="noopener noreferrer">
              {data.user.login}
            </a>
          </div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>Должность</div>
          <div className={css.b__field}>{data.user.position}</div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>Департамент</div>
          <div className={css.b__field}>{data.user.deparmentPath}</div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>Офис</div>
          <div className={css.b__field}>
            {data.user.officeName} - {data.user.cityName} - {data.user.countryName}
          </div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>TimeZone</div>
          <div className={css.b__field}>{data.user.timeZone}</div>
        </div>
        <div className={css.b__row}>
          <div className={css.b__label}>Флаги</div>
          <div className={css.b__field}>
            {tags
              .filter((tag) => data.user[tag.name] > 0)
              .map((tag) => (
                <Tag key={tag.name} color={tag.color} size="xxs">
                  {tag.text}
                </Tag>
              ))}
          </div>
        </div>
        <NativeForm
          key={hash}
          config={config}
          initialValues={initialValues}
          data={data}
          units={units}
        />
      </div>
    </div>
  );
};

export default Form;
