import * as React from 'react';
import renderTemplate, { Template } from './renderTemplate';
import { FormFieldsController } from './utils/FormFieldsController';
import { Data, Unit } from './types';

interface Props {
  initialValues?: unknown;
  config?: unknown;
  data?: Data;
  units: Unit[];
}

class NativeForm extends React.Component<Props> {
  private formRef = React.createRef<HTMLDivElement>();
  private formFieldsController: FormFieldsController;

  public componentDidMount(): void {
    const { config, initialValues, data, units } = this.props;

    this.formFieldsController = new FormFieldsController(this.formRef, {
      config,
      initialValues,
      data,
      units,
    });
    this.formFieldsController.setNodeListeners();
    this.formFieldsController.initialSetFieldsVisibility(initialValues);
    this.template.componentDidMount.forEach((func): void => {
      func();
    });
  }

  public componentDidUpdate(): void {
    this.template.componentDidMount.forEach((func): void => {
      func();
    });
  }

  private template: Template;

  public render(): React.ReactNode {
    const { initialValues, config } = this.props;

    this.template = renderTemplate({ config, initialValues });

    return <div ref={this.formRef} dangerouslySetInnerHTML={{ __html: this.template.html }} />;
  }
}

export default NativeForm;
