import { AnyObject } from 'final-form';
import css from './renderBlock.module.css';
import { renderInput, InputProps } from './renderTemplate';
import { idPrefix } from './utils/idPrefix';

export interface RenderBlockProps {
  type: 'block';
  label?: string;
  value?: AnyObject;
  fieldId?: string;
  children?: AnyObject[];
  description?: string;
  useOriginalValue?: boolean;
  css: {
    [key: string]: string;
  };
}

export const renderBlock = (props: RenderBlockProps): string => {
  const { label, children, css: cssProp, value, fieldId = '', useOriginalValue = false } = props;

  const description = props.description
    ? `<div class="${css.block__description}">${props.description}</div>`
    : '';

  return `<div id="${idPrefix}_${fieldId}" class="${css.block}"><div class="${
    css.block__label
  }">${label}</div>${description}<div class="${css.block__content}">${(children || [])
    .map((child) => {
      const inputValue = useOriginalValue ? child.value : value;
      return renderInput({
        ...child,
        css: cssProp,
        value: inputValue,
        useOriginalValue,
      } as InputProps);
    })
    .join('')}</div></div>`;
};
