import { YaCallsUnitKind } from 'types/YaCallsUnitKind';

export interface Channel {
  name: string;
  type: number;
  priority: number;
  limit: number;
  realtime: boolean;
}

export interface Props {
  mainRole: number;
  roles: number;
}

export interface SysRole {
  id: number;
  name: string;
  code: string;
}

export interface ButtonAccess {
  id: string;
  label: string;
  value: boolean;
}

export interface SysCity {
  id: number;
  name?: string;
}

export interface TicketAssignmentModeOption {
  id: string;
  name: string;
}

export interface Data {
  channels: Channel[];
  props: Props;
  sysRoles: SysRole[];
  sysCities: SysCity[];
  ticketAssignmentModes: TicketAssignmentModeOption[];
  spQueue: unknown[];
  buttonAccesses: ButtonAccess[];
  personalPostCallTimeout?: number;
  personalUnit?: number;
  realtimeTotalLimit?: number;
}

export interface Unit {
  id: number;
  name: string;
  kind: keyof YaCallsUnitKind;
}
