import {
  GetHiddenFieldsProps,
  HiddenGroup,
  FieldGroup,
  GetFieldsProps,
} from './getHiddenFields.types';

const personalUnitBlock: GetFieldsProps = (form) => {
  const ticketAssignmentMode = form.ticketAssignmentMode;

  if (ticketAssignmentMode === '1') {
    const channel1 = form['channels[1].on_off_manual'];
    const channel2 = form['channels[2].on_off_manual'];
    if (channel1 || channel2) return [];
  } else if (ticketAssignmentMode === '2') {
    const channel1 = form['channels[1].priority'];
    const channel2 = form['channels[2].priority'];
    if (channel1 !== '0' || channel2 !== '0') return [];
  }

  return ['personalUnitBlock'];
};

const personalUnitGroup: GetFieldsProps = (form) => {
  if (form.personalUnit === '0') {
    return [
      'personalPostCallTimeout',
      'escalationUnit1',
      'escalationUnit2',
      'escalationDialTimeout',
    ];
  }

  if (form.escalationUnit1 === '0') return ['escalationUnit2', 'escalationDialTimeout'];

  return [];
};

const fieldsToCheckMap: FieldGroup[] = [
  {
    checkKey: (key) => /(ticketAssignmentMode|channels\[\d\]\.[on_off_manual,priority])/.test(key),
    getFields: personalUnitBlock,
    groupName: 'personalUnitBlock',
  },
  {
    checkKey: (key) => ['personalUnit', 'escalationUnit1'].includes(key),
    getFields: personalUnitGroup,
    groupName: 'personalUnitGroup',
  },
];

export const getHiddenFields = ({ initiator = '', form, checkAll }: GetHiddenFieldsProps) => {
  const hiddenGroups: HiddenGroup[] = [];
  for (const { checkKey, getFields, groupName } of fieldsToCheckMap) {
    if (checkAll || checkKey(initiator)) {
      hiddenGroups.push({ groupName, hiddenIds: getFields(form) });
    }
  }
  return hiddenGroups;
};
