import { AnyObject } from 'react-final-form';

export interface HiddenGroup {
  groupName: string;
  hiddenIds: string[];
}

export type GetHiddenFieldsProps = { form: AnyObject } & (
  | {
      initiator: string;
      checkAll?: never;
    }
  | {
      initiator?: never;
      checkAll: true;
    }
);

export type GetFieldsProps = (form: AnyObject) => string[];

export interface FieldGroup {
  checkKey: (name: string) => boolean;
  getFields: GetFieldsProps;
  groupName: string;
}
