import { get } from 'api/common';
import { Unit } from '../types';

type UpdateFetcher = (params: {
  evt;
  values;
  initialValues: { userId: number };
  units?: Unit[];
}) => unknown;

const fetchButtonAccesses: UpdateFetcher = ({ evt, initialValues }) =>
  get({
    url: '/admin/sysuser/user/buttonAccesses',
    data: {
      TicketAssignmentMode: evt.target.value,
      userId: initialValues.userId,
    },
  });

const updatePersonalUnitsBlock: UpdateFetcher = ({ values, units }) => ({ values, units });

export const updateFetcher: Record<string, UpdateFetcher> = {
  buttonAccesses: fetchButtonAccesses,
  personalUnitBlock: updatePersonalUnitsBlock,
};
