import * as React from 'react';
import { get } from 'api/common';
import Textinput from '@crm/components/dist/lego2/Textinput';
import cx from 'classnames';
import { connect } from 'react-redux';
import redux from '../../redux';
import ListItem from './ListItem';
import { User } from '../../types';
import css from './List.scss';

interface State {
  text: string;
}

interface Props {
  url: string;
  className: string;
  get: () => void;
  items: User[];
}

class List extends React.Component<Props, State> {
  public state = { text: '' };

  public componentDidMount() {
    this.promise = this.props.get();
  }

  public componentWillUnmount() {
    if (this.promise) {
      this.promise.cancel();
    }
  }

  private handleChange = (text) => {
    this.setState({ text });
  };

  private promise: any;

  public render() {
    const { text } = this.state;
    const { items, className, url } = this.props;

    const lowCaseText = String(text).toLowerCase();

    return (
      <div className={cx(css.b, className)}>
        <div className={css.b__header}>
          <Textinput placeholder="Поиск" value={text} onChange={this.handleChange} autoFocus />
        </div>
        {Array.isArray(items) && (
          <div className={css.b__list}>
            {items
              .filter(
                (item) =>
                  String(item.fullName)
                    .toLowerCase()
                    .indexOf(lowCaseText) !== -1 ||
                  String(item.login)
                    .toLowerCase()
                    .indexOf(lowCaseText) !== -1,
              )
              .map((item) => (
                <ListItem url={url} key={item.userId} user={item} />
              ))}
          </div>
        )}
      </div>
    );
  }
}

export default connect((state) => ({ items: redux.selectors.items(state) }), {
  get: redux.actions.list.get,
})(List);
