import * as React from 'react';
import { NavLink } from 'react-router-dom';
import Tag from 'lego/components/Tag';
import css from './ListItem.scss';
import { User } from '../../types';
import { TAG_COLOR } from '../../constants';

interface Props {
  user: User;
  url: string;
}

interface Tag {
  name: string;
  color: string;
}

const ListItem = React.memo((props: Props) => {
  const {
    user: { fullName, login, userId, isSupport, isAdmin },
    url,
  } = props;

  const tags: Tag[] = [];
  if (isAdmin) {
    tags.push({
      name: 'Админ',
      color: TAG_COLOR.ADMIN,
    });
  }

  if (isSupport) {
    tags.push({
      name: 'Поддержка',
      color: TAG_COLOR.SUPPORT,
    });
  }

  return (
    <NavLink to={`${url}/${userId}`} className={css.b} activeClassName={css.b_active}>
      {fullName} <span className={css.b__login}>({login})</span>
      {!!tags.length && (
        <span className={css.b__tags}>
          {tags.map(tag => (
            <Tag key={tag.name} color={tag.color} size="xxxs">
              {tag.name}
            </Tag>
          ))}
        </span>
      )}
    </NavLink>
  );
});

export default ListItem;
