import { push } from 'modules/notificationsUI/actions';

export default ({ actionTypes }) => {
  const actions = {
    module: {
      destroy: () => ({ type: actionTypes.module.DESTROY }),
    },
    list: {
      get() {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.list.get.REQUEST,
            actionTypes.list.get.RECEIVE,
            actionTypes.list.get.FAIL,
          ],
          args: {
            url: '/admin/sysuser/list',
            type: 'GET',
          },
        };
      },
    },
    form: {
      destroy: () => ({ type: actionTypes.form.DESTROY }),
      get(id) {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.form.get.REQUEST,
            actionTypes.form.get.RECEIVE,
            actionTypes.form.get.FAIL,
          ],
          args: {
            url: '/admin/sysuser/user',
            data: {
              userId: id,
            },
            type: 'GET',
          },
        };
      },
      getUnits() {
        return {
          type: 'FETCH',
          actions: [
            actionTypes.form.getUnits.REQUEST,
            actionTypes.form.getUnits.RECEIVE,
            actionTypes.form.getUnits.FAIL,
          ],
          args: {
            url: '/admin/yacalls/units',
            type: 'GET',
          },
        };
      },
      post(data) {
        return (dispatch) => {
          dispatch({
            type: 'FETCH',
            json: true,
            actions: [
              actionTypes.form.post.REQUEST,
              actionTypes.form.post.RECEIVE,
              actionTypes.form.post.FAIL,
            ],
            args: {
              url: '/admin/sysuser/user/save',
              type: 'POST',
              data,
            },
          }).then((responseData) => {
            dispatch(
              push({
                theme: 'success',
                text: 'Карточка сохранена',
              }),
            );
            dispatch(actions.form.get(data.userId));
            return responseData;
          });
        };
      },
    },
  };

  return actions;
};
