import createActionTypes from './createActionTypes';
import createActions from './createActions';
import createReducer from './createReducer';
import createSelectors from './createSelectors';

const createRedux = (path: string) => {
  const actionTypes = createActionTypes(path);
  const selectors = createSelectors(path);

  const actions = createActions({
    actionTypes,
  });

  const result = {
    actionTypes,
    actions,
    reducer: createReducer(actionTypes),
    selectors,
  };

  window.reduxStore.injectReducer(path, result.reducer);

  return result;
};

export default createRedux('adminPanel/users');
