import * as React from 'react';
import url from 'utils/url';
import TitleChain from 'modules/heading';
import Layout from './components/Layout';

const UserRouter = props => {
  const { id } = props.match.params;
  const parsedId = parseInt(id, 10) || null;
  const query = url.queryToObject(props.location.search);

  return (
    <React.Fragment>
      <TitleChain>Пользователи</TitleChain>
      <Layout id={parsedId} query={query} {...props} />
    </React.Fragment>
  );
};

export default UserRouter;
