import memoize from 'memoize-one';
import { shallowEqual } from 'react-redux';
import { AnyObject } from 'final-form';

const calculateArrayPristine = <TValues extends Array<AnyObject>>(
  initialValues: TValues,
  values: TValues,
): boolean => {
  return initialValues.every((item, index) => {
    return shallowEqual(item, values[index]);
  });
};

const calculateObjectPristine = <TValues extends Record<string, AnyObject>>(
  initialValues: TValues,
  values: TValues,
): boolean => {
  const keys = Object.keys(initialValues);
  return keys.every((key) => {
    return shallowEqual(initialValues[key], values[key]);
  });
};

export const calculatePristineByValues = memoize(
  <TValues extends Array<AnyObject> | Record<string, AnyObject>>(
    initialValues: TValues,
    values: TValues,
  ): boolean => {
    if (initialValues === values) {
      return true;
    }

    if (Array.isArray(initialValues) && Array.isArray(values)) {
      return calculateArrayPristine(initialValues, values);
    }

    return calculateObjectPristine(
      initialValues as Record<string, AnyObject>,
      values as Record<string, AnyObject>,
    );
  },
);
