/*
eslint-disable no-restricted-globals
*/

import React from 'react';
import { connect } from 'react-redux';
import Popup from '@crm/components/dist/lego2/Popup';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import { Direction } from '@crm/components/dist/lego2/withOldDirections';
import * as keyset from '../attributes.i18n';
import redux from '../redux';
import FormContainer from './FormContainer';

const i18n = createI18N(keyset);
const i18nConfigureFields = i18n('configureFields');
const i18nSubmitSuccessConfirm = i18n('submitSuccessConfirm');

const DIRECTIONS: Direction[] = ['bottom-right', 'bottom-center', 'bottom-left'];
const buttonMargin = 7;

interface Props {
  unload: () => {};
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  save: (data: any) => void;
  loadByKey: (appearanceKey: string) => void;
  onSubmitSuccess: () => void;
  isLoad: boolean;
  isFetch: boolean;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  data: any;
  className: string;
  appearanceKey: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  initialValues: any;
}

class AttributesPopup extends React.Component<Props> {
  private button: React.RefObject<HTMLElement> = React.createRef();

  public componentWillUnmount() {
    this.props.unload();
  }

  private toggle = (): void => {
    if (!this.props.isLoad) {
      this.props.loadByKey(this.props.appearanceKey);
    } else {
      this.props.unload();
    }
  };

  private handleSubmitSuccess = () => {
    const { unload, onSubmitSuccess } = this.props;

    if (typeof onSubmitSuccess === 'function') {
      if (confirm(i18nSubmitSuccessConfirm)) {
        unload();
        onSubmitSuccess();
      }
    } else {
      unload();
    }
  };

  private handleSave = (values) => {
    this.props.save({
      key: this.props.appearanceKey,
      settings: values,
    });
  };

  public render() {
    const { isLoad, isFetch, data = {}, unload, className } = this.props;

    return (
      <span className={className}>
        <Button onClick={this.toggle} innerRef={this.button} progress={isFetch}>
          {i18nConfigureFields}
        </Button>
        <Popup
          visible={isLoad}
          onOutsideClick={unload}
          target="anchor"
          anchor={this.button}
          mainOffset={buttonMargin}
          directions={DIRECTIONS}
          zIndex={5}
        >
          <FormContainer
            onSubmit={this.handleSave}
            onCancel={unload}
            onSubmitSuccess={this.handleSubmitSuccess}
            groups={data.meta}
            initialValues={data.initialValues}
            groupName={data.groupName}
          />
        </Popup>
      </span>
    );
  }
}

export default connect(redux.selectors.getState, redux.actions)(AttributesPopup);
