import * as React from 'react';
import { Field as FormField } from 'redux-form';
import CheckBox from 'lego/redux-form/CheckBox';

interface Props {
  text: React.ReactNode;
  name: string;
}

const parse = value => !!value;

const Field = (props: Props) => {
  const { text, name } = props;
  return (
    <div>
      <FormField parse={parse} name={name} component={CheckBox} lines="multi">
        {text}
      </FormField>
    </div>
  );
};

export default Field;
