import React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import { reduxForm, InjectedFormProps } from 'redux-form';
import ReactBuilder from 'components/ReactBuilder';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Form from 'components/Form';
import Empty from 'components/Empty';
import Group, { ProviderGroup } from 'modules/groups';
import * as keyset from '../attributes.i18n';
import Field from './Field';
import css from './Form.scss';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nNoData = i18n('noData');
const i18nNothingFound = i18n('nothingFound');
const i18nFieldSearch = i18n('fieldSearch');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');

const COMPONENTS = {
  Field,
  Group,
};

export interface Props {
  // eslint-disable-next-line
  groups: any;
  onSearch: (text: string) => void;
  onCancel: () => {};
  search: string;
  groupName: string;
  isSearch: boolean;
  isEmpty: boolean;
  isEmptySearch: boolean;
}

const AttributesForm: React.FC<Props & InjectedFormProps<{}, Props>> = (props) => {
  const {
    groups,
    groupName,
    onSearch,
    search,
    onCancel,
    handleSubmit,
    isSearch,
    isEmpty,
    isEmptySearch,
  } = props;

  if (isEmpty) {
    return (
      <div className={css.b}>
        <Empty icon="storage" text={i18nNoData} />
      </div>
    );
  }

  let body: React.ReactNode = null;

  if (isEmptySearch) {
    body = <Empty text={i18nNothingFound} />;
  } else {
    body = (
      <ProviderGroup name={groupName} show={isSearch}>
        <ReactBuilder meta={groups} components={COMPONENTS} />
      </ProviderGroup>
    );
  }

  return (
    <Form onSubmit={handleSubmit} theme="popup" className={css.b}>
      <Form.Header>
        <Textinput autoFocus value={search} onChange={onSearch} placeholder={i18nFieldSearch} />
      </Form.Header>
      <Form.Body>{body}</Form.Body>
      <Form.Footer>
        <Button view="action" type="submit">
          {i18nSave}
        </Button>
        <Button onClick={onCancel}>{i18nCancel}</Button>
      </Form.Footer>
    </Form>
  );
};

export default reduxForm<{}, Props>({ form: 'attributes' })(AttributesForm);
