import React from 'react';
import escapeRegExp from 'lodash/escapeRegExp';
import filterTree from 'utils/filterTree';
import debounce from 'lodash/debounce';
import Form from './Form';

interface Props {
  groups: any;
  groupName: string;
  onCancel: () => {};
  onSubmit: (data: any) => void;
  onSubmitSuccess: () => void;
  initialValues: any;
}

interface State {
  search: string;
  groups: any;
  isEmpty: boolean;
  isSearch: boolean;
  isEmptySearch: boolean;
}

class AttributesFormContainer extends React.Component<Props, State> {
  public constructor(props) {
    super(props);

    this.filter = debounce(this.filter, 200);
    this.state = {
      search: '',
      groups: props.groups,
      isEmpty: !props.groups,
      isSearch: false,
      isEmptySearch: false,
    };
  }

  private handleSearch = (value: string) => {
    this.setState({ search: value });
    this.filter(value);
  };

  private filter = (value: string) => {
    if (value) {
      const searchPattern = new RegExp(`(${escapeRegExp(value)})`, 'im');

      const predicate = node => {
        const nodeProps = (node && node.props) || {};
        return node.component === 'Field' && searchPattern.test(nodeProps.text);
      };

      const result = filterTree({ node: this.props.groups, predicate });

      this.setState({
        groups: result,
        isSearch: true,
        isEmptySearch: !result,
      });
    } else {
      this.setState({ groups: this.props.groups, isEmptySearch: false, isSearch: false });
    }
  };

  public render() {
    return <Form {...this.props} {...this.state} onSearch={this.handleSearch} />;
  }
}

export default AttributesFormContainer;
