/*
eslint-disable import/prefer-default-export
*/

import isPromise from 'is-promise';
import { get, jsonApiCall } from 'api/common';
import backendAdapter from '../utils/backendAdapter';
import { REQUEST, RECEIVE, FAIL, UNLOAD } from './actionTypes';

export const load = provider => dispatch => {
  if (typeof provider === 'function') {
    dispatch({ type: REQUEST });
    const result = provider();
    if (isPromise(result)) {
      result
        .then(data => {
          dispatch({ type: RECEIVE, payload: backendAdapter(data) });
          return data;
        })
        .catch(e => {
          dispatch({ type: FAIL });
          throw e;
        });
    } else {
      dispatch({ type: RECEIVE, payload: result });
    }
  } else {
    console.error('Provider is not function');
  }
};

/**
 * @param data {Object}
 * @param data.key {String}
 * @param data.settings {Object}
 * */
export const save = data => () =>
  jsonApiCall({
    url: '/actions/usersettings/appearance/save',
    data,
  });

export const loadByKey = (key = 'appearance.account.Client') =>
  load(() =>
    get({
      url: '/view/usersettings/appearance',
      data: { key },
    }),
  );

export const unload = () => ({ type: UNLOAD });
