import reducerFactoryRaw from 'utils/reducer/reducerFactoryRaw';
import { REQUEST, RECEIVE, FAIL, UNLOAD } from './actionTypes';

const INIT = {
  unreadCount: 0,
};

const behaviors = {
  [REQUEST](state) {
    return {
      ...state,
      isLoad: false,
      isFetch: true,
    };
  },
  [RECEIVE](state, { payload }) {
    return {
      ...state,
      data: payload,
      isLoad: true,
      isFetch: false,
    };
  },
  [FAIL](state) {
    return {
      ...state,
      isLoad: false,
      isFetch: false,
    };
  },
  [UNLOAD](state) {
    return {
      ...state,
      isLoad: false,
    };
  },
};

export default reducerFactoryRaw(null, behaviors, INIT);
