import treeConvertor from 'utils/treeConvertor';

let groupName;
let initialValues;

const convertor = node => {
  const result = {};
  result.component = node.type;

  switch (node.type) {
    case 'Root': {
      initialValues = {};
      result.component = 'div';
      groupName = node.name;
      break;
    }
    case 'Group': {
      result.props = {
        groupName,
        header: node.text,
        name: node.name,
        key: node.name,
      };
      break;
    }
    case 'Field': {
      initialValues[node.name] = node.value;
      result.props = {
        text: node.text,
        name: node.name,
        key: node.name,
      };
      break;
    }
    default:
      break;
  }

  return result;
};

export default data => {
  const result = {
    meta: treeConvertor({ node: data, func: convertor, newChildrenSlug: 'content' }),
  };

  result.initialValues = initialValues;
  result.groupName = groupName;
  return result;
};
