import throttle from 'lodash/throttle';

const mediaTypes: MediaType[] = ['wav', 'mpeg'];
export type MediaType = 'mpeg' | 'wav';

export const createPlay = (
  urlOrTypeMap: string | Record<MediaType, string>,
  options?: {
    throttle?: number;
    volume?: number;
  },
) => {
  const audio = new Audio();
  let url = '';
  if (typeof urlOrTypeMap === 'string') {
    url = urlOrTypeMap;
  } else {
    for (let i = 0; i < mediaTypes.length; i++) {
      const mediaType = mediaTypes[i];
      const mediaTypeUrl = urlOrTypeMap[mediaType];
      if (!mediaTypeUrl) {
        continue;
      }

      if (audio.canPlayType(`audio/${mediaType}`)) {
        url = mediaTypeUrl;
      }
    }
  }
  audio.setAttribute('src', url);

  if (options?.volume != null) {
    audio.volume = options.volume;
  }

  let isLoaded = false;
  audio.addEventListener('canplaythrough', () => {
    isLoaded = true;
  });

  const play = () => {
    if (isLoaded) {
      audio.play();
    }
  };

  return {
    play: options?.throttle ? throttle(play, options.throttle) : play,
  };
};
