import React, { createContext, useContext, FC, useState, useEffect } from 'react';

export const globalAudioContext = createContext((null as unknown) as HTMLAudioElement);
export const useGlobalAudioContext = () => useContext(globalAudioContext);
export const GlobalAudioProvider: FC = ({ children }) => {
  const [audio] = useState(new Audio());

  useEffect(
    () => () => {
      audio.pause();
    },
    [],
  );

  return <globalAudioContext.Provider value={audio}>{children}</globalAudioContext.Provider>;
};
