import React, { Component } from 'react';
import PropTypes from 'prop-types';
import authorization from './withAuthorization';
import { getAuthProps } from './moduleAuthorization';

const AuthWrapper = authorization()();

export default class Authorization extends Component {
  constructor(props) {
    super(props);
    this.authParams = getAuthProps(this.props.access);
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.access !== nextProps.access) {
      this.authParams = getAuthProps(nextProps.access);
    }
  }

  render() {
    const { showError, errorComponent } = this.props;

    return (
      <AuthWrapper {...this.authParams} errorComponent={showError ? errorComponent : null}>
        {this.props.children}
      </AuthWrapper>
    );
  }
}

Authorization.propTypes = {
  access: PropTypes.string.isRequired,
  children: PropTypes.node.isRequired,
  errorComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
  showError: PropTypes.bool,
};

Authorization.defaultProps = {
  errorComponent: undefined,
  showError: false,
};
