import get from 'lodash/get';
import authorization from './withAuthorization';

export const getAuthProps = (param, config) => {
  let calcCanView = () => false;
  if (typeof param === 'string') {
    calcCanView = state => get(state, `root.info.modules.${param}`);
  } else if (typeof param === 'function') {
    calcCanView = state => param(get(state, 'root.info.modules', {}));
  }

  return {
    authorizationCondition: props => props.canView,
    getReduxState: state => ({ canView: calcCanView(state) }),
    ...config,
  };
};

export const moduleAuthorization = (param, config) => authorization(getAuthProps(param, config));

export const createAuthorizationComponent = moduleName => moduleAuthorization(moduleName)();
