import React, { createElement } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import hoistNonReactStatic from 'hoist-non-react-statics';
import getDisplayName from 'utils/getDisplayName';
import Error from './Error';

const authorization = config => WrappedComponent => {
  let Authorization = ({ authorizationCondition, getReduxState, errorComponent, ...props }) => {
    if (typeof authorizationCondition !== 'function') {
      console.warn('miss or not function: authorizationCondition in Authorization');
      return <span>miss or not function: authorizationCondition in Authorization</span>;
    }
    if (authorizationCondition(props)) {
      if (WrappedComponent) {
        return <WrappedComponent {...props} />;
      }

      return props.children;
    }

    if (!errorComponent) {
      return null;
    }
    return createElement(errorComponent);
  };

  Authorization = connect((state, props) => {
    if (typeof props.getReduxState === 'function') {
      return props.getReduxState(state, props);
    }
    return null;
  })(Authorization);

  Authorization.propTypes = {
    authorizationCondition: PropTypes.func,
    getReduxState: PropTypes.func,
    errorComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
    children: PropTypes.node,
  };
  Authorization.defaultProps = {
    errorComponent: Error,
    children: undefined,
    ...config,
  };

  if (WrappedComponent) {
    Authorization.displayName = `Authorization(${getDisplayName(WrappedComponent)})`;
    hoistNonReactStatic(Authorization, WrappedComponent);
  }

  return Authorization;
};

export default authorization;
