import React from 'react';
import { Field } from 'react-final-form';
import CheckBox from 'lego/final-form/CheckBox';
import { Field as IField } from '../types';
import css from './Form.module.css';

interface Props {
  field: IField;
}

const FormCheckBox: React.FC<Props> = (props) => {
  return (
    <div className={css.b__checkboxWrap}>
      <Field key={props.field.name} name={props.field.name} component={CheckBox}>
        {props.field.label}
      </Field>
    </div>
  );
};

export default FormCheckBox;
