import React from 'react';
import { Field } from 'react-final-form';
import TextInput from 'lego/final-form/TextInput';
import { Field as IField } from '../types';
import css from './Form.module.css';

interface Props {
  field: IField;
}

const FormTextInput: React.FC<Props> = (props) => {
  return (
    <div className={css.b__field}>
      <span className={css.b__label}>{props.field.label}</span>
      <Field
        key={props.field.name}
        name={props.field.name}
        component={TextInput}
        placeholder={props.field.label}
      />
    </div>
  );
};

export default FormTextInput;
