import * as React from 'react';
import { Route, Switch, NavLink, RouteComponentProps } from 'react-router-dom';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import config from '../config';
import Report from './Report';
import css from './Layout.module.css';

const withAuth = moduleAuthorization('billing');

const Layout = ({ match }: RouteComponentProps) => (
  <div className={css.b}>
    <div className={css.b__list}>
      {config.list.map(key => (
        <NavLink
          to={`${match.url}/${key}`}
          className={css.b__listItem}
          activeClassName={css.b__listItem_active}
        >
          {config.map[key].title}
        </NavLink>
      ))}
    </div>
    <Switch>
      {config.list.map(key => (
        <Route
          key={key}
          path={`${match.url}/${key}`}
          render={() => <Report className={css.b__report} config={config.map[key]} />}
        />
      ))}
    </Switch>
  </div>
);

export default withAuth(Layout);
