import { ConfigScheme, FieldComponent } from './types';

const config: ConfigScheme = {
  map: {
    invoice: {
      title: 'Счет',
      requestUrl: '/view/billing/invoice',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'invoiceNumber',
          label: 'Номер счета',
        },
      ],
    },
    checkPromocode: {
      title: 'Отчет Проверка промокода',
      requestUrl: '/view/billing/checkPromocode',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'promocode',
          label: 'Промокод',
        },
      ],
    },
    promocodes: {
      title: 'Отчет Промокоды клиента',
      requestUrl: '/view/billing/promocodes',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'login',
          label: 'Логин клиента',
        },
      ],
    },
    invoices: {
      title: 'Список счетов клиента',
      requestUrl: '/view/billing/invoices',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'login',
          label: 'Логин клиента',
        },
        {
          component: FieldComponent.CheckBox,
          name: 'hasUnusedFunds',
          label: 'С наличием свободных средств',
        },
      ],
    },
    persons: {
      title: 'Плательщики',
      requestUrl: '/view/billing/persons',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'login',
          label: 'Логин клиента',
        },
      ],
    },
    noorder: {
      title: 'Беззаказье',
      requestUrl: '/view/billing/noorder',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'login',
          label: 'Логин клиента',
        },
      ],
    },
    checkDomainForPromoCode: {
      title: 'Проверка домена для промокода',
      requestUrl: '/view/billing/checkDomainForPromoCode',
      fields: [
        {
          component: FieldComponent.TextInput,
          name: 'domainName',
          label: 'Домен',
        },
      ],
    },
  },
  list: [
    'checkPromocode',
    'promocodes',
    'invoice',
    'invoices',
    'persons',
    'noorder',
    'checkDomainForPromoCode',
  ],
};

export default config;
