export enum FieldComponent {
  TextInput = 'TextInput',
  CheckBox = 'CheckBox',
}

export interface Field {
  component: FieldComponent;
  name: string;
  label: string;
}

export interface ConfigScheme {
  map: {
    [key: string]: Config;
  };
  list: string[];
}

export interface Config {
  title: string;
  fields: Field[];
  requestUrl: string;
}

export interface Table {
  title: string;
  html: string;
  eof: boolean;
  id: string;
}

export interface Response {
  tables: Table[];
}

export interface ResponseMore {
  tableId: string;
  html: string;
  eof: boolean;
}
