import React from 'react';
import ModuleIcon from 'components/ModuleIcon';
import Icon from '@crm/components/dist/lego2/Icon';
import BugReportModal from './BugReportModal';

const BugReport = ({ className, open, close, show, onSuccess }) => (
  <React.Fragment>
    <button type="button" className={className} onClick={open} title="Помощь">
      <ModuleIcon icon={(cls) => <Icon className={cls} svg="help" svgSize="l" />} />
    </button>
    <BugReportModal visible={show} onClose={close} onSuccess={onSuccess} />
  </React.Fragment>
);

export default BugReport;
