import React from 'react';
import { push } from 'modules/notificationsUI/actions';
import { connect } from 'react-redux';
import BugReport from './BugReport';

@connect()
export default class BugReportController extends React.Component {
  state = {
    show: false,
  };

  open = () => { this.setState({ show: true }); };
  close = () => { this.setState({ show: false }); };
  onSuccess = () => {
    this.props.dispatch(push({ theme: 'success', text: 'Форма отправлена' }));
    this.close();
  };

  render() {
    return (
      <BugReport
        open={this.open}
        close={this.close}
        onSuccess={this.onSuccess}
        {...this.state}
        {...this.props}
      />
    );
  }
}
