import React from 'react';
import cx from 'classnames';
import { InfiniteListView } from 'containers/InfiniteList';
import Empty from 'components/Empty';
import { Category } from './Category.connect';
import css from './CategoriesList.scss';
import CategoriesSearch from './CategoriesSearch';

const CategoryContainerAdapter = (props) => <Category category={props.data} />;

const CategoriesList = ({ className, text, onLoad, onTextChange, onSubmit, name }) => (
  <div className={cx(className, css.b)}>
    <CategoriesSearch value={text} onChange={onTextChange} onSubmit={onSubmit} />
    <InfiniteListView
      className={css.b__list}
      withNavigation={false}
      name={name}
      onLoad={onLoad}
      component={CategoryContainerAdapter}
      reloadOnLoadUpdate
      emptyComponent={<Empty text="" icon="search" />}
    />
  </div>
);

export default CategoriesList;
