import React from 'react';
import Metrika from 'modules/metrika';
import debounce from 'lodash/debounce';
import CategoriesList from './CategoriesList';
import { reduxContext } from '../ReduxContext';
import { loadList } from '../../api';

class CategoriesListContainer extends React.Component {
  static contextType = reduxContext;

  constructor(props) {
    super(props);

    this.state = {
      onLoad: loadList,
      text: '',
    };

    this.debounceSubmit = debounce(this.debounceSubmit, 300);
  }

  componentWillUnmount() {
    this.debounceSubmit.cancel();
  }

  onTextChange = (text) => {
    const { onTextChange } = this.props;
    if (onTextChange) {
      onTextChange(text);
    }
    this.setText(text);
  };

  getText = () => this.state.text;

  setText(text) {
    if (text === this.state.text) {
      return;
    }

    this.setState({ text });
    this.debounceSubmit();
  }

  onSubmit = () => {
    this.debounceSubmit.cancel();
    this.submit();
  };

  debounceSubmit = () => {
    const { text } = this.state;
    if (text && text.length >= 2) {
      this.submit();
    }
  };

  submit() {
    const { text } = this.state;

    Metrika.reachGoal('categorizator_search_query');

    if (text) {
      this.setState({
        onLoad: (args) => this.context.loadList({ ...args, text }),
      });
    }
  }

  render() {
    const { onTextChange, onSubmit, state } = this;
    const { text, onLoad } = state;
    const { name } = this.props;

    return (
      <CategoriesList
        name={name}
        onLoad={onLoad}
        text={text}
        onTextChange={onTextChange}
        onSubmit={onSubmit}
      />
    );
  }
}

export default CategoriesListContainer;
