import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Textinput from '@crm/components/dist/lego2/Textinput';
import css from './CategoriesList.scss';

interface Props {
  value: string;
  onChange: () => {};
  onSubmit: () => {};
}

class CategoriesSearch extends React.Component<Props> {
  inputNode: any = React.createRef();

  handleSubmit = (e) => {
    e.preventDefault();
    e.stopPropagation();

    this.props.onSubmit();
    this.inputNode.current.focus();
  };

  render() {
    const { onChange, value } = this.props;

    return (
      <form className={css.b__search} onSubmit={this.handleSubmit}>
        <Textinput
          onChange={onChange}
          value={value}
          placeholder="Поиск вопроса"
          pin="round-clear"
          ref={this.inputNode}
        />
        <Button type="submit" disabled={!value} pin="brick-round">
          Найти
        </Button>
      </form>
    );
  }
}

export default CategoriesSearch;
