import React, { useContext, useCallback } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import Metrika from 'modules/metrika';
import CategoryBase from './Category';
import { reduxContext } from '../ReduxContext';

export const Category = (props) => {
  const redux = useContext(reduxContext);
  const value = useSelector((state) => redux.getCategoryValue(state, props.category.id));
  const dispatch = useDispatch();

  const onSetCategory = useCallback(
    (categoryId, isReason) => {
      dispatch(redux.loadCategory({ categoryId }));

      if (isReason) {
        Metrika.reachGoal('categorizator_reason_select', {
          category_id: categoryId,
        });
        return;
      }

      Metrika.reachGoal('categorizator_category_select', {
        category_id: categoryId,
      });
    },
    [dispatch, redux],
  );

  const onRemoveCategory = useCallback(
    (categoryId, isReason) => {
      dispatch(
        redux.actions.remove({
          categoryId: props.category.id,
          subCategoryId: categoryId !== props.category.id ? categoryId : undefined,
        }),
      );

      if (isReason) {
        Metrika.reachGoal('categorizator_reason_delete', {
          category_id: categoryId,
        });
        return;
      }

      Metrika.reachGoal('categorizator_category_delete', {
        category_id: categoryId,
      });
    },
    [dispatch, props.category.id, redux.actions],
  );

  return (
    <CategoryBase
      {...props}
      value={value}
      onSetCategory={onSetCategory}
      onRemoveCategory={onRemoveCategory}
    />
  );
};
