import React from 'react';
import Checkbox from '@crm/components/dist/lego2/Checkbox';
import Metrika from 'modules/metrika';
import WordBreak from 'components/WordBreak';
import { TipButton } from '../TipButton';
import Category from '../Category';
import css from './Category.scss';

class CategoryItem extends React.Component {
  handleToggle = (value, id, isReason) => {
    const { onSetCategory, onRemoveCategory } = this.props;

    if (value) {
      onSetCategory(id, isReason);
    } else {
      onRemoveCategory(id, isReason);
    }
  };

  handleClickTip = () => {
    Metrika.reachGoal('categorizator_tip_link');
  };

  handleChangeCategory = (v) => {
    const { category } = this.props;
    this.handleToggle(v, category.id);
  };

  render() {
    const { category, value } = this.props;
    const { items, tipUrl } = category;

    let reasons = null;
    if (Array.isArray(items)) {
      reasons = items.map((item) => (
        <div key={item.id}>
          <Checkbox
            checked={value && Boolean(value[item.id])}
            onChange={(v) => this.handleToggle(v, item.id, true)}
          >
            <Category category={item} saasHighlight />
            &nbsp;
            {item.tipUrl && <TipButton url={item.tipUrl} onClick={this.handleClickTip} />}
          </Checkbox>
        </div>
      ));
    }

    return (
      <WordBreak className={css.b}>
        <span className={css.b__question}>
          <Checkbox checked={Boolean(value)} onChange={this.handleChangeCategory}>
            <Category category={category} showFullName saasHighlight />
            &nbsp;
            {tipUrl && <TipButton url={tipUrl} onClick={this.handleClickTip} />}
          </Checkbox>
        </span>
        <span className={css.b__reason}>{reasons}</span>
      </WordBreak>
    );
  }
}

export default CategoryItem;
