import React, { memo } from 'react';
import WordBreak from 'components/WordBreak';
import css from './CategoriesPreview.scss';
import Category from '../Category';
import { CategoriesPreviewProps } from './CategoriesPreview.types';

export const CategoriesPreview = memo((props: CategoriesPreviewProps) => {
  const { categories } = props;

  if (!Array.isArray(categories)) {
    return null;
  }

  return (
    <WordBreak>
      {categories.map((category) => {
        let reasons =
          (Array.isArray(category.items) &&
            category.items
              .filter((reason) => reason.selected)
              .map((reason) => ({
                element: <Category key={reason.id} category={reason} />,
                id: reason.id,
              }))) ||
          [];

        const len = Array.isArray(reasons) && reasons.length;
        let reasonsWithSpace: JSX.Element[] = [];
        if (len) {
          reasonsWithSpace = reasons.reduce((ac, reason, index) => {
            ac.push(reason.element);
            if (index !== len - 1) {
              ac.push(<span key={`d${reason.id}`}>,&nbsp;</span>);
            }

            return ac;
          }, reasonsWithSpace);
        }
        return (
          <div key={category.id}>
            <span className={css.b__question}>
              <Category category={category} showFullName />
              {len > 0 && <span>&nbsp;-&nbsp;</span>}
            </span>
            {reasonsWithSpace}
          </div>
        );
      })}
    </WordBreak>
  );
});
