import React, { useMemo, memo, FC } from 'react';
import { CategoriesPreview } from './CategoriesPreview';
import { CategoriesPreviewFromValueProps } from './CategoriesPreviewFromValue.types';

export const CategoriesPreviewFromValue = memo(((props) => {
  const categories = useMemo(() => {
    if (!props.value) {
      return [];
    }

    return Object.values(props.value.categories);
  }, [props.value]);

  return <CategoriesPreview categories={categories} />;
}) as FC<CategoriesPreviewFromValueProps>);
