import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Metrika from 'modules/metrika';
import Button from '@crm/components/dist/lego2/Button';
import Icon2 from '@crm/components/dist/lego2/Icon';
import Select from '@crm/components/dist/lego2/Select';
import ToolTip from 'lego/components/ToolTip';
import cx from 'classnames';
import Icon from 'lego/components/Icon';
import css from './Category.scss';

const clearIconProvider = (iconCls) => <Icon2 className={iconCls} type="cross" />;

class Category extends Component {
  onReasonChange = (ids) => {
    const { onSet, value } = this.props;
    const arrValue = value ? Object.values(value) : [];

    onSet(ids);
    const prevIds = arrValue;
    const reasonWasRemoved = prevIds.length > ids.length;
    if (reasonWasRemoved) {
      const removedReason = prevIds.find((prevId) => !ids.some((id) => prevId === id));
      Metrika.reachGoal('categorizator_reason_delete', {
        category_id: removedReason,
      });
    } else {
      const addedReason = ids.find((id) => !prevIds.some((prevId) => id === prevId));
      Metrika.reachGoal('categorizator_reason_select', {
        category_id: addedReason,
      });
    }
  };

  render() {
    const { category, onRemove, value } = this.props;

    const arrValue = value ? Object.values(value) : [];

    if (!category || !value) {
      return null;
    }

    const { fullName, items } = category;

    const isReasons = Array.isArray(items) && items.length;
    let isSomeInstructions = false;
    const allInstructions =
      isReasons &&
      items.map(({ id, instructions }) => {
        if (value[id] && instructions) {
          isSomeInstructions = true;
          return <div key={id}>{instructions}</div>;
        }

        return null;
      });

    return (
      <div className={css.b}>
        <span className={cx(css.b__cell, css.b__cell_remove)}>
          <Button view="clear" onClick={onRemove} size="xs" icon={clearIconProvider} />
        </span>
        <span className={cx(css.b__cell, css.b__cell_question)}>{fullName}</span>
        <span className={cx(css.b__cell, css.b__cell_quantity)}>
          {isReasons && arrValue.length > 1 && arrValue.length}
        </span>
        <span className={cx(css.b__cell, css.b__cell_reasons)}>
          {isReasons && (
            <Select
              size="xs"
              value={arrValue}
              onChange={this.onReasonChange}
              hasEmptyValue={false}
              options={items.map((item) => ({ value: String(item.id), content: item.name }))}
              width="max"
            />
          )}
          {isSomeInstructions && (
            <ToolTip tooltip={allInstructions}>
              <Icon pack={Icon.PACKS.MATERIAL} icon="info" />
            </ToolTip>
          )}
        </span>
      </div>
    );
  }
}

Category.propTypes = {
  category: PropTypes.shape({
    fullName: PropTypes.string,
    items: PropTypes.arrayOf(
      PropTypes.shape({
        id: PropTypes.number,
        instructions: PropTypes.string,
      }),
    ),
  }).isRequired,
  onRemove: PropTypes.func.isRequired,
  onSet: PropTypes.func.isRequired,
  value: PropTypes.arrayOf(PropTypes.number).isRequired,
};

export default Category;
