import React from 'react';
import Tag from 'lego/components/Tag';
import { Category } from '../../types';
import css from './Category.scss';

interface Props {
  category: Category;
  onRemove: () => void;
}

const CategoryTag: React.FC<Props> = (props) => {
  return (
    <Tag
      onDelete={props.onRemove}
      className={css.categoryTag}
      theme="clear"
      title={props.category.fullName}
    >
      {props.category.name || props.category.fullName}
    </Tag>
  );
};

export default CategoryTag;
