import React from 'react';
import { connectCategory } from './connectCategory';
import Category from './Category';
import { CategorizationValue } from '../../types';
import css from './Category.scss';

const ConnectedCategory = connectCategory(Category);

interface Props {
  value: CategorizationValue;
}

const DefaultList: React.FC<Props> = (props) => {
  return (
    <div className={css.categoriesWrap}>
      {Object.values(props.value.categories).map((category) => (
        <ConnectedCategory key={category.id} category={category} />
      ))}
    </div>
  );
};

export default DefaultList;
