import React, { ComponentType } from 'react';
import cx from 'classnames';
import Access from 'utils/Access';
import Icon from 'lego/components/Icon';
import { CategorizationValue, Category } from '../../types';
import { connectCategory } from './connectCategory';
import CategoryTag from './CategoryTag';
import css from './Category.scss';

const ConnectedCategoryTag = connectCategory(CategoryTag);

interface Props {
  value: CategorizationValue;
  isRequireMarkup: number;
  className?: string;
  CategoryTagComponent?: ComponentType<{
    category: Category;
  }>;
}

const TagList: React.FC<Props> = (props) => {
  const categories = Object.values(props.value.categories);
  const { isRequireMarkup, CategoryTagComponent = ConnectedCategoryTag } = props;

  if (categories.length) {
    return (
      <div className={cx(props.className, css.categoryTagsWrap)}>
        {categories.map((category) => (
          <CategoryTagComponent key={category.id} category={category} />
        ))}
      </div>
    );
  }
  if (Access.isRead(isRequireMarkup)) {
    return (
      <div className={cx(props.className, css.categoryTagsWrap)}>
        <Icon pack={Icon.PACKS.MATERIAL} icon="warning" className={css.warningIcon} />
        требуется разметка
      </div>
    );
  }

  return null;
};

export default TagList;
