import React, { useContext } from 'react';
import { useSelector } from 'react-redux';
import { reduxContext } from '../ReduxContext';

export const connectCategories = (WrappedComponent) => {
  const ConnectCategories = (props) => {
    const redux = useContext(reduxContext);
    const value = useSelector(redux.getState);

    return <WrappedComponent value={value} {...props} />;
  };

  return ConnectCategories;
};
