import React, { useContext, useCallback } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import Metrika from 'modules/metrika';
import { reduxContext } from '../ReduxContext';

export const connectCategory = (WrappedComponent) => {
  const ConnectCategories = (props) => {
    const redux = useContext(reduxContext);
    const dispatch = useDispatch();
    const value = useSelector((state) => redux.getCategoryValue(state, props.category.id));

    const onSet = useCallback(
      (categoryId) => dispatch(redux.actions.set({ categoryId, category: props.category })),
      [dispatch, props.category, redux.actions],
    );

    const onRemove = useCallback(() => {
      Metrika.reachGoal('categorizator_category_delete', {
        category_id: props.category.id,
      });
      dispatch(redux.actions.removeV3({ categoryId: props.category.id }));
    }, [dispatch, props.category, redux.actions]);

    return <WrappedComponent value={value} onSet={onSet} onRemove={onRemove} {...props} />;
  };

  return ConnectCategories;
};
