import React, { useContext, useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import Metrika from 'modules/metrika';
import debounce from 'lodash/debounce';
import CategoriesTreeBase from 'modules/adminPanel/modules/categories/components/Categories/CategoriesTree';
import { reduxContext } from '../ReduxContext';

const TEXT_CHANGE_DEBOUNCE_DELAY = 300;
const onTextChange = debounce(() => {
  Metrika.reachGoal('categorizator_search_query');
  Metrika.reachGoal('categorizator_search_results');
}, TEXT_CHANGE_DEBOUNCE_DELAY);

const canItemClick = (item) => item.available;

const onArrowClick = (id) => {
  Metrika.reachGoal('categorizator_tree_click', {
    category_id: id,
  });
};

export const CategoriesTree = (props) => {
  const redux = useContext(reduxContext);
  const value = useSelector(redux.getSelectedMap);
  const dispatch = useDispatch();

  const handleClick = useCallback(
    (categoryId, category, isSelected) => {
      if (isSelected) {
        const args: number[] = [];
        if (category.isReason && category.parentId) {
          args.push(category.parentId);

          dispatch(
            redux.actions.remove({ categoryId: category.parentId, subCategoryId: categoryId }),
          );
        } else {
          dispatch(redux.actions.remove({ categoryId }));
        }

        Metrika.reachGoal('categorizator_category_delete', {
          category_id: categoryId,
        });
      } else {
        Metrika.reachGoal('categorizator_category_select', {
          category_id: categoryId,
        });
        dispatch(redux.loadCategory({ categoryId }));
      }
    },
    [dispatch, redux],
  );

  return (
    <CategoriesTreeBase
      selected={value}
      selectedType="map"
      endpoint={redux.treeApi}
      canItemClick={canItemClick}
      onTextChange={onTextChange}
      onArrowClick={onArrowClick}
      onClick={handleClick}
      {...props}
    />
  );
};
