import React, { useContext, useMemo, useEffect, useRef, useCallback, ComponentType } from 'react';
import { bindActionCreators } from 'redux';
import { useDispatch, useSelector } from 'react-redux';
import { CategorizationConnectProps } from './Categorization.types';
import { Categorization as CategorizationBase } from './Categorization';
import { reduxContext } from '../ReduxContext';
import { withReduxContext } from '../ReduxContext';
import { VALUE_FROM_TYPE_KEY, ValueFromType } from '../../types';

export const Categorization = withReduxContext(((props) => {
  const redux = useContext(reduxContext);
  const innerValue = useSelector(redux.getState);
  const dispatch = useDispatch();
  const mount = useRef(false);

  let { initialValue, value, onChange } = props;

  initialValue = initialValue || value;

  const setValueFromOutside = useMemo(() => {
    return bindActionCreators(redux.actions.setValueFromOutside, dispatch);
  }, [dispatch, redux.actions.setValueFromOutside]);

  useEffect(() => {
    if (initialValue) {
      setValueFromOutside(initialValue);
    }
  }, [setValueFromOutside, initialValue]);
  const onTipClick = useCallback((url) => window.open(url), []);
  useEffect(() => {
    if (mount.current && onChange && innerValue[VALUE_FROM_TYPE_KEY] === ValueFromType.Inside) {
      onChange(innerValue);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [innerValue]);

  useEffect(() => {
    mount.current = true;
  }, []);

  return <CategorizationBase value={innerValue} onTipClick={onTipClick} {...props} />;
}) as ComponentType<CategorizationConnectProps>);
