import { ComponentType } from 'react';
import { TipCallback } from '../TipButton';
import { WithReduxContextProps } from '../ReduxContext';
import { CategorizationValue } from '../../types';

export interface WithSearchController {
  setText: (text: string) => void;
  getText: () => string;
}

export interface CategorizationProps extends WithReduxContextProps {
  preview?: ComponentType;
  onClose?: () => void;
  onOpen?: () => void;
  onToggle?: (isOpen: boolean) => void;
  onTipClick: TipCallback;
  className?: string;
  theme?: string;
  value: CategorizationValue;
  onChange?: (value: CategorizationValue | { id: number }[]) => void;
  name: string;
  id?: number;
  eType?: string;
  isRequireMarkup?: number;
  targetDescription?: string;
}

export type CategorizationConnectOptionalType = 'onTipClick' | 'value';

export type CategorizationConnectProps = Omit<
  CategorizationProps,
  CategorizationConnectOptionalType
> &
  Partial<Pick<CategorizationProps, CategorizationConnectOptionalType>> & {
    initialValue?: CategorizationValue;
    /** @deprecated use initialValue */
    value?: CategorizationValue;
  };

export interface CategorizationState {
  isOpen: boolean;
  tabIndex: number;
}
