import React from 'react';
import SaasHighlight from 'components/SaasHighlight';
import Select from 'components/Select';
import Icon from 'lego/components/Icon';
import css from './Category.scss';

interface CategoryType {
  name: string;
  fullName: string;
  highlightedName?: string;
  searchRange: number[];
  // eslint-disable-next-line
  tags: any[];
  top: boolean;
}

interface Props {
  category: CategoryType;
  showFullName: boolean;
  saasHighlight: boolean;
}

const Category = (props: Props) => {
  const { category } = props;

  if (!category) {
    return null;
  }

  const { showFullName, saasHighlight } = props;
  const { name, fullName, searchRange, highlightedName, top } = category;

  let categoryElement;
  if (saasHighlight && highlightedName) {
    categoryElement = <SaasHighlight html={highlightedName} />;
  } else {
    categoryElement = <Select value={showFullName ? fullName : name} range={searchRange} />;
  }

  return (
    <span>
      {categoryElement}
      {top && <Icon pack={Icon.PACKS.MATERIAL} icon="star" className={css.b__top} />}
    </span>
  );
};

Category.defaultProps = {
  category: undefined,
  showFullName: false,
};

export default Category;
