import { useSelector } from 'react-redux';

export const SafeReduxInitState = ({ stateKey, children }) => {
  const hasState = useSelector<{}, boolean>((state) => Boolean(state[stateKey]));

  if (!hasState) {
    return null;
  }

  return children;
};
